<?php

$footerPage = new HudsonEdgeAdminPage(
	"3",
	esc_html__( "Footer", 'hudson' ),
	"fa fa-sort-amount-asc"
);
$hudson_edge_framework->edgtOptions->addAdminPage(
	"footer",
	$footerPage
);

$panel10 = new HudsonEdgePanel(
	esc_html__( "Footer", 'hudson' ),
	"footer_panel"
);
$footerPage->addChild(
	"panel10",
	$panel10
);

$uncovering_footer = new HudsonEdgeField(
	"yesno",
	"uncovering_footer",
	"no",
	esc_html__( "Uncovering Footer", 'hudson' ),
	esc_html__( "Enabling this option will make Footer gradually appear on scroll", 'hudson' )
);
$panel10->addChild(
	"uncovering_footer",
	$uncovering_footer
);

$footer_in_grid = new HudsonEdgeField(
	"yesno",
	"footer_in_grid",
	"yes",
	esc_html__( "Footer in Grid", 'hudson' ),
	esc_html__( "Enabling this option will place Footer content in grid", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_footer_grid_background_container"
	)
);
$panel10->addChild(
	"footer_in_grid",
	$footer_in_grid
);

$footer_main_image_background = new HudsonEdgeField(
	"image",
	"footer_main_image_background",
	"",
	esc_html__( "Footer Background Image", 'hudson' ),
	esc_html__( "Choose footer background image", 'hudson' )
);
$panel10->addChild(
	"footer_main_image_background",
	$footer_main_image_background
);

$show_footer_top = new HudsonEdgeField(
	"yesno",
	"show_footer_top",
	"yes",
	esc_html__( "Show Footer Top", 'hudson' ),
	esc_html__( "Enabling this option will show Footer Top area", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_show_footer_top_container"
	)
);
$panel10->addChild(
	"show_footer_top",
	$show_footer_top
);

$show_footer_top_container = new HudsonEdgeContainer(
	"show_footer_top_container",
	"show_footer_top",
	"no"
);
$panel10->addChild(
	"show_footer_top_container",
	$show_footer_top_container
);

$footer_top_columns_alignment = new HudsonEdgeField(
	"select",
	"footer_top_columns_alignment",
	"",
	esc_html__( "Footer Top Columns Alignment", 'hudson' ),
	esc_html__( "Text Alignment in Footer Columns", 'hudson' ),
	array(
		"left" => esc_html__( "Left", 'hudson' ),
		"center" => esc_html__( "Center", 'hudson' ),
		"right" => esc_html__( "Right", 'hudson' )
	)
);
$show_footer_top_container->addChild(
	"footer_top_columns_alignment",
	$footer_top_columns_alignment
);

$footer_top_columns = new HudsonEdgeField(
	"select",
	"footer_top_columns",
	"4",
	esc_html__( "Footer Top Columns", 'hudson' ),
	esc_html__( "Choose number of columns for Footer Top area", 'hudson' ),
	array(
		"1" => "1",
		"2" => "2",
		"3" => "3",
		"5" => esc_html__( "3(25%+25%+50%)", 'hudson' ),
		"6" => esc_html__( "3(50%+25%+25%)", 'hudson' ),
		"4" => "4"
	),
	array(
		"dependence" => true,
		"hide"       => array(
			"1" => "#edgtf_footer_top_column2_alignment_container,#edgtf_footer_top_column3_alignment_container,#edgtf_footer_top_column4_alignment_container",
			"2" => "#edgtf_footer_top_column3_alignment_container,#edgtf_footer_top_column4_alignment_container",
			"3" => "#edgtf_footer_top_column4_alignment_container",
			"4" => "",
			"5" => "#edgtf_footer_top_column4_alignment_container",
			"6" => "#edgtf_footer_top_column4_alignment_container"
		),
		"show"       => array(
			"1" => "#edgtf_footer_top_column1_alignment_container",
			"2" => "#edgtf_footer_top_column1_alignment_container,#edgtf_footer_top_column2_alignment_container",
			"3" => "#edgtf_footer_top_column1_alignment_container,#edgtf_footer_top_column2_alignment_container,#edgtf_footer_top_column3_alignment_container",
			"4" => "#edgtf_footer_top_column1_alignment_container,#edgtf_footer_top_column2_alignment_container,#edgtf_footer_top_column3_alignment_container,#edgtf_footer_top_column4_alignment_container",
			"5" => "#edgtf_footer_top_column1_alignment_container,#edgtf_footer_top_column2_alignment_container,#edgtf_footer_top_column3_alignment_container",
			"6" => "#edgtf_footer_top_column1_alignment_container,#edgtf_footer_top_column2_alignment_container,#edgtf_footer_top_column3_alignment_container",
		)
	)
);
$show_footer_top_container->addChild(
	"footer_top_columns",
	$footer_top_columns
);

$footer_top_column1_alignment_container = new HudsonEdgeContainer(
	"footer_top_column1_alignment_container",
	"footer_top_columns",
	""
);
$show_footer_top_container->addChild(
	"footer_top_column1_alignment_container",
	$footer_top_column1_alignment_container
);

$footer_top_column1_alignment = new HudsonEdgeField(
	"select",
	"footer_top_column1_alignment",
	"",
	esc_html__( "Footer Top First Column Alignment", 'hudson' ),
	esc_html__( "This option will overwrite 'Footer Top Columns Alignment'", 'hudson' ),
	array(
		"" => esc_html__( "Default", 'hudson' ),
		"left" => esc_html__( "Left", 'hudson' ),
		"center" => esc_html__( "Center", 'hudson' ),
		"right" => esc_html__( "Right", 'hudson' )
	),
	array( "col_width" => 3 )
);
$footer_top_column1_alignment_container->addChild(
	"footer_top_column1_alignment",
	$footer_top_column1_alignment
);

$footer_top_column2_alignment_container = new HudsonEdgeContainer(
	"footer_top_column2_alignment_container",
	"footer_top_columns",
	"1"
);
$show_footer_top_container->addChild(
	"footer_top_column2_alignment_container",
	$footer_top_column2_alignment_container
);

$footer_top_column2_alignment = new HudsonEdgeField(
	"select",
	"footer_top_column2_alignment",
	"",
	esc_html__( "Footer Top Second Column Alignment", 'hudson' ),
	esc_html__( "This option will overwrite 'Footer Top Columns Alignment'", 'hudson' ),
	array(
		"" => esc_html__( "Default", 'hudson' ),
		"left" => esc_html__( "Left", 'hudson' ),
		"center" => esc_html__( "Center", 'hudson' ),
		"right" => esc_html__( "Right", 'hudson' )
	),
	array( "col_width" => 3 )
);
$footer_top_column2_alignment_container->addChild(
	"footer_top_column2_alignment",
	$footer_top_column2_alignment
);

$footer_top_column3_alignment_container = new HudsonEdgeContainer(
	"footer_top_column3_alignment_container",
	"footer_top_columns",
	"1",
	array( "1", "2" )
);
$show_footer_top_container->addChild(
	"footer_top_column3_alignment_container",
	$footer_top_column3_alignment_container
);

$footer_top_column3_alignment = new HudsonEdgeField(
	"select",
	"footer_top_column3_alignment",
	"",
	esc_html__( "Footer Top Third Column Alignment", 'hudson' ),
	esc_html__( "This option will overwrite 'Footer Top Columns Alignment'", 'hudson' ),
	array(
		"" => esc_html__( "Default", 'hudson' ),
		"left" => esc_html__( "Left", 'hudson' ),
		"center" => esc_html__( "Center", 'hudson' ),
		"right" => esc_html__( "Right", 'hudson' )
	),
	array( "col_width" => 3 )
);
$footer_top_column3_alignment_container->addChild(
	"footer_top_column3_alignment",
	$footer_top_column3_alignment
);

$footer_top_column4_alignment_container = new HudsonEdgeContainer(
	"footer_top_column4_alignment_container",
	"footer_top_columns",
	"1",
	array( "1", "2", "3", "5", "6" )
);
$show_footer_top_container->addChild(
	"footer_top_column4_alignment_container",
	$footer_top_column4_alignment_container
);

$footer_top_column4_alignment = new HudsonEdgeField(
	"select",
	"footer_top_column4_alignment",
	"",
	esc_html__( "Footer Top Fourth Column Alignment", 'hudson' ),
	esc_html__( "This option will overwrite 'Footer Top Columns Alignment'", 'hudson' ),
	array(
		"" => esc_html__( "Default", 'hudson' ),
		"left" => esc_html__( "Left", 'hudson' ),
		"center" => esc_html__( "Center", 'hudson' ),
		"right" => esc_html__( "Right", 'hudson' )
	),
	array( "col_width" => 3 )
);
$footer_top_column4_alignment_container->addChild(
	"footer_top_column4_alignment",
	$footer_top_column4_alignment
);

$footer_border_columns = new HudsonEdgeField(
	"yesno",
	"footer_border_columns",
	"yes",
	esc_html__( "Border Between Columns", 'hudson' ),
	esc_html__( "Disabling this option will remove border between footer columns.", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_footer_border_columns_holder"
	)
);
$show_footer_top_container->addChild(
	"footer_border_columns",
	$footer_border_columns
);

$footer_border_columns_holder = new HudsonEdgeContainer(
	"footer_border_columns_holder",
	"footer_border_columns",
	"no"
);
$show_footer_top_container->addChild(
	"footer_border_columns_holder",
	$footer_border_columns_holder
);

$footer_border_columns_color = new HudsonEdgeField(
	"color",
	"footer_border_columns_color",
	"",
	esc_html__( "Border Color Between Columns", 'hudson' ),
	esc_html__( "Choose a color for border in footer columns.", 'hudson' )
);
$footer_border_columns_holder->addChild(
	"footer_border_columns_color",
	$footer_border_columns_color
);

$footer_bottom_border_element = new HudsonEdgeField(
	"yesno",
	"footer_bottom_border_element",
	"yes",
	esc_html__( "Border Bottom on Elements", 'hudson' ),
	esc_html__( "Enabling this option will add border bottom on footer elements.", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_footer_bottom_border_element_holder"
	)
);
$show_footer_top_container->addChild(
	"footer_bottom_border_element",
	$footer_bottom_border_element
);

$footer_bottom_border_element_holder = new HudsonEdgeContainer(
	"footer_bottom_border_element_holder",
	"footer_bottom_border_element",
	"no"
);
$show_footer_top_container->addChild(
	"footer_bottom_border_element_holder",
	$footer_bottom_border_element_holder
);

$footer_bottom_border_element_color = new HudsonEdgeField(
	"color",
	"footer_bottom_border_element_color",
	"",
	esc_html__( "Border Bottom Color", 'hudson' ),
	esc_html__( "Choose a color for border in footer columns.", 'hudson' )
);
$footer_bottom_border_element_holder->addChild(
	"footer_bottom_border_element_color",
	$footer_bottom_border_element_color
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Footer Top Area Style", 'hudson' ),
	esc_html__( "Configure style for Footer Top area", 'hudson' )
);
$show_footer_top_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);
$footer_top_background_color = new HudsonEdgeField(
	"colorsimple",
	"footer_top_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"footer_top_background_color",
	$footer_top_background_color
);

$footer_top_border_color = new HudsonEdgeField(
	"colorsimple",
	"footer_top_border_color",
	"",
	esc_html__( "Top Border Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"footer_top_border_color",
	$footer_top_border_color
);

$footer_top_border_width = new HudsonEdgeField(
	"textsimple",
	"footer_top_border_width",
	"",
	esc_html__( "Top Border Width (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"footer_top_border_width",
	$footer_top_border_width
);

$footer_top_border_in_grid = new HudsonEdgeField(
	"yesnosimple",
	"footer_top_border_in_grid",
	"no",
	esc_html__( "Set Top Border In Grid", 'hudson' ),
	""
);
$row1->addChild(
	"footer_top_border_in_grid",
	$footer_top_border_in_grid
);

$row2 = new HudsonEdgeRow( true );
$group1->addChild(
	"row2",
	$row2
);

$footer_top_padding = new HudsonEdgeField(
	"textsimple",
	"footer_top_padding",
	"",
	esc_html__( "Top Padding (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"footer_top_padding",
	$footer_top_padding
);

$footer_bottom_padding = new HudsonEdgeField(
	"textsimple",
	"footer_bottom_padding",
	"",
	esc_html__( "Bottom Padding (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"footer_bottom_padding",
	$footer_bottom_padding
);

$footer_left_padding = new HudsonEdgeField(
	"textsimple",
	"footer_left_padding",
	"",
	esc_html__( "Left Padding (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"footer_left_padding",
	$footer_left_padding
);

$footer_right_padding = new HudsonEdgeField(
	"textsimple",
	"footer_right_padding",
	"",
	esc_html__( "Right Padding (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"footer_right_padding",
	$footer_right_padding
);

$footer_grid_background_container = new HudsonEdgeContainer(
	"footer_grid_background_container",
	"footer_in_grid",
	"no"
);
$show_footer_top_container->addChild(
	"footer_grid_background_container",
	$footer_grid_background_container
);

$footer_top_background_color_in_grid = new HudsonEdgeField(
	"color",
	"footer_top_background_color_in_grid",
	"",
	esc_html__( "Grid Background Color", 'hudson' ),
	esc_html__( "Choose background color for grid on footer top", 'hudson' )
);
$footer_grid_background_container->addChild(
	"footer_top_background_color_in_grid",
	$footer_top_background_color_in_grid
);

$footer_image_background = new HudsonEdgeField(
	"image",
	"footer_image_background",
	"",
	esc_html__( "Footer Top Background Image", 'hudson' ),
	esc_html__( "Choose footer top background image", 'hudson' )
);
$show_footer_top_container->addChild(
	"footer_image_background",
	$footer_image_background
);

$group2 = new HudsonEdgeGroup(
	esc_html__( "Footer Top Title Style", 'hudson' ),
	esc_html__( "Configure style for Footer Top Title", 'hudson' )
);
$show_footer_top_container->addChild(
	"group2",
	$group2
);

$row1 = new HudsonEdgeRow();
$group2->addChild(
	"row1",
	$row1
);

$footer_title_color = new HudsonEdgeField(
	"colorsimple",
	"footer_title_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"footer_title_color",
	$footer_title_color
);

$footer_title_font_size = new HudsonEdgeField(
	"textsimple",
	"footer_title_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"footer_title_font_size",
	$footer_title_font_size
);

$footer_title_line_height = new HudsonEdgeField(
	"textsimple",
	"footer_title_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"footer_title_line_height",
	$footer_title_line_height
);

$footer_title_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"footer_title_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row1->addChild(
	"footer_title_text_transform",
	$footer_title_text_transform
);

$row2 = new HudsonEdgeRow( true );
$group2->addChild(
	"row2",
	$row2
);
$footer_title_font_family = new HudsonEdgeField(
	"fontsimple",
	"footer_title_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"footer_title_font_family",
	$footer_title_font_family
);

$footer_title_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"footer_title_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"footer_title_font_style",
	$footer_title_font_style
);

$footer_title_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"footer_title_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"footer_title_font_weight",
	$footer_title_font_weight
);

$footer_title_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"footer_title_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"footer_title_letter_spacing",
	$footer_title_letter_spacing
);

$group3 = new HudsonEdgeGroup(
	esc_html__( "Footer Top Text Style", 'hudson' ),
	esc_html__( "Configure style for Footer Top text", 'hudson' )
);
$show_footer_top_container->addChild(
	"group3",
	$group3
);

$row1 = new HudsonEdgeRow();
$group3->addChild(
	"row1",
	$row1
);
$footer_top_text_color = new HudsonEdgeField(
	"colorsimple",
	"footer_top_text_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"footer_top_text_color",
	$footer_top_text_color
);

$footer_top_text_font_size = new HudsonEdgeField(
	"textsimple",
	"footer_top_text_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"footer_top_text_font_size",
	$footer_top_text_font_size
);

$footer_top_text_line_height = new HudsonEdgeField(
	"textsimple",
	"footer_top_text_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"footer_top_text_line_height",
	$footer_top_text_line_height
);

$footer_top_text_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"footer_top_text_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row1->addChild(
	"footer_top_text_text_transform",
	$footer_top_text_text_transform
);

$row2 = new HudsonEdgeRow( true );
$group3->addChild(
	"row2",
	$row2
);
$footer_top_text_font_family = new HudsonEdgeField(
	"fontsimple",
	"footer_top_text_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"footer_top_text_font_family",
	$footer_top_text_font_family
);

$footer_top_text_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"footer_top_text_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"footer_top_text_font_style",
	$footer_top_text_font_style
);

$footer_top_text_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"footer_top_text_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"footer_top_text_font_weight",
	$footer_top_text_font_weight
);

$footer_top_text_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"footer_top_text_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"footer_top_text_letter_spacing",
	$footer_top_text_letter_spacing
);

$group4 = new HudsonEdgeGroup(
	esc_html__( "Footer Top Link Style", 'hudson' ),
	esc_html__( "Configure style for Footer Top link", 'hudson' )
);
$show_footer_top_container->addChild(
	"group4",
	$group4
);

$row1 = new HudsonEdgeRow();
$group4->addChild(
	"row1",
	$row1
);
$footer_top_link_color = new HudsonEdgeField(
	"colorsimple",
	"footer_top_link_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"footer_top_link_color",
	$footer_top_link_color
);

$footer_top_link_font_size = new HudsonEdgeField(
	"textsimple",
	"footer_top_link_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"footer_top_link_font_size",
	$footer_top_link_font_size
);

$footer_top_link_line_height = new HudsonEdgeField(
	"textsimple",
	"footer_top_link_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"footer_top_link_line_height",
	$footer_top_link_line_height
);

$footer_top_link_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"footer_top_link_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row1->addChild(
	"footer_top_link_text_transform",
	$footer_top_link_text_transform
);

$row2 = new HudsonEdgeRow( true );
$group4->addChild(
	"row2",
	$row2
);
$footer_top_link_font_family = new HudsonEdgeField(
	"fontsimple",
	"footer_top_link_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"footer_top_link_font_family",
	$footer_top_link_font_family
);

$footer_top_link_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"footer_top_link_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"footer_top_link_font_style",
	$footer_top_link_font_style
);

$footer_top_link_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"footer_top_link_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"footer_top_link_font_weight",
	$footer_top_link_font_weight
);

$footer_top_link_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"footer_top_link_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"footer_top_link_letter_spacing",
	$footer_top_link_letter_spacing
);

$row3 = new HudsonEdgeRow( true );
$group4->addChild(
	"row3",
	$row3
);
$footer_top_link_hover_color = new HudsonEdgeField(
	"colorsimple",
	"footer_top_link_hover_color",
	"",
	esc_html__( "Hover Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"footer_top_link_hover_color",
	$footer_top_link_hover_color
);

$footer_text = new HudsonEdgeField(
	"yesno",
	"footer_text",
	"yes",
	esc_html__( "Show Footer Bottom", 'hudson' ),
	esc_html__( "Enabling this option will show Footer Bottom area", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_footer_text_container"
	)
);
$panel10->addChild(
	"footer_text",
	$footer_text
);

$footer_text_container = new HudsonEdgeContainer(
	"footer_text_container",
	"footer_text",
	"no"
);
$panel10->addChild(
	"footer_text_container",
	$footer_text_container
);

$footer_bottom_columns = new HudsonEdgeField(
	"select",
	"footer_bottom_columns",
	"3",
	esc_html__( "Footer Bottom Columns", 'hudson' ),
	esc_html__( "Choose number of columns for Footer Bottom area", 'hudson' ),
	array(
		"1" => "1",
		"2" => "2",
		"3" => "3"
	)
);
$footer_text_container->addChild(
	"footer_bottom_columns",
	$footer_bottom_columns
);

$group5 = new HudsonEdgeGroup(
	esc_html__( "Footer Bottom Area Style", 'hudson' ),
	esc_html__( "Configure style for Footer Bottom area", 'hudson' )
);
$footer_text_container->addChild(
	"group5",
	$group5
);

$row1 = new HudsonEdgeRow();
$group5->addChild(
	"row1",
	$row1
);
$footer_bottom_height = new HudsonEdgeField(
	"textsimple",
	"footer_bottom_height",
	"",
	esc_html__( "Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"footer_bottom_height",
	$footer_bottom_height
);
$footer_bottom_background_color = new HudsonEdgeField(
	"colorsimple",
	"footer_bottom_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"footer_bottom_background_color",
	$footer_bottom_background_color
);

$footer_bottom_border_in_grid = new HudsonEdgeField(
	"yesnosimple",
	"footer_bottom_border_in_grid",
	"no",
	esc_html__( "Set Top Border In Grid", 'hudson' ),
	""
);
$row1->addChild(
	"footer_bottom_border_in_grid",
	$footer_bottom_border_in_grid
);

$row2 = new HudsonEdgeRow( true );
$group5->addChild(
	"row2",
	$row2
);

$footer_bottom_border_color = new HudsonEdgeField(
	"colorsimple",
	"footer_bottom_border_color",
	"",
	esc_html__( "Top Border Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"footer_bottom_border_color",
	$footer_bottom_border_color
);
$footer_bottom_border_width = new HudsonEdgeField(
	"textsimple",
	"footer_bottom_border_width",
	"",
	esc_html__( "Top Border Width (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"footer_bottom_border_width",
	$footer_bottom_border_width
);
$footer_bottom_border_bottom_color = new HudsonEdgeField(
	"colorsimple",
	"footer_bottom_border_bottom_color",
	"",
	esc_html__( "Bottom Border Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"footer_bottom_border_bottom_color",
	$footer_bottom_border_bottom_color
);
$footer_bottom_border_bottom_width = new HudsonEdgeField(
	"textsimple",
	"footer_bottom_border_bottom_width",
	"",
	esc_html__( "Bottom Border Width (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"footer_bottom_border_bottom_width",
	$footer_bottom_border_bottom_width
);

$row3 = new HudsonEdgeRow( true );
$group5->addChild(
	"row3",
	$row3
);

$footer_bottom_top_padding = new HudsonEdgeField(
	"textsimple",
	"footer_bottom_top_padding",
	"",
	esc_html__( "Top Padding (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"footer_bottom_top_padding",
	$footer_bottom_top_padding
);
$footer_bottom_bottom_padding = new HudsonEdgeField(
	"textsimple",
	"footer_bottom_bottom_padding",
	"",
	esc_html__( "Bottom Padding (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"footer_bottom_bottom_padding",
	$footer_bottom_bottom_padding
);
$footer_bottom_left_padding = new HudsonEdgeField(
	"textsimple",
	"footer_bottom_left_padding",
	"",
	esc_html__( "Left Padding (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"footer_bottom_left_padding",
	$footer_bottom_left_padding
);
$footer_bottom_right_padding = new HudsonEdgeField(
	"textsimple",
	"footer_bottom_right_padding",
	"",
	esc_html__( "Right Padding (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"footer_bottom_right_padding",
	$footer_bottom_right_padding
);

$footer_bottom_image_background = new HudsonEdgeField(
	"image",
	"footer_bottom_image_background",
	"",
	esc_html__( "Footer Bottom Background Image", 'hudson' ),
	esc_html__( "Choose footer bottom background image", 'hudson' )
);
$footer_text_container->addChild(
	"footer_bottom_image_background",
	$footer_bottom_image_background
);

$group6 = new HudsonEdgeGroup(
	esc_html__( "Footer Bottom Text Style", 'hudson' ),
	esc_html__( "Configure style for Footer Bottom text", 'hudson' )
);
$footer_text_container->addChild(
	"group6",
	$group6
);

$row1 = new HudsonEdgeRow();
$group6->addChild(
	"row1",
	$row1
);

$footer_bottom_text_color = new HudsonEdgeField(
	"colorsimple",
	"footer_bottom_text_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"footer_bottom_text_color",
	$footer_bottom_text_color
);

$footer_bottom_text_font_size = new HudsonEdgeField(
	"textsimple",
	"footer_bottom_text_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"footer_bottom_text_font_size",
	$footer_bottom_text_font_size
);

$footer_bottom_text_line_height = new HudsonEdgeField(
	"textsimple",
	"footer_bottom_text_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"footer_bottom_text_line_height",
	$footer_bottom_text_line_height
);

$footer_bottom_text_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"footer_bottom_text_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row1->addChild(
	"footer_bottom_text_text_transform",
	$footer_bottom_text_text_transform
);

$row2 = new HudsonEdgeRow( true );
$group6->addChild(
	"row2",
	$row2
);

$footer_bottom_text_font_family = new HudsonEdgeField(
	"fontsimple",
	"footer_bottom_text_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"footer_bottom_text_font_family",
	$footer_bottom_text_font_family
);

$footer_bottom_text_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"footer_bottom_text_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"footer_bottom_text_font_style",
	$footer_bottom_text_font_style
);

$footer_bottom_text_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"footer_bottom_text_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"footer_bottom_text_font_weight",
	$footer_bottom_text_font_weight
);

$footer_bottom_text_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"footer_bottom_text_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"footer_bottom_text_letter_spacing",
	$footer_bottom_text_letter_spacing
);

$group7 = new HudsonEdgeGroup(
	esc_html__( "Footer Bottom Link Style", 'hudson' ),
	esc_html__( "Configure style for Footer Bottom link", 'hudson' )
);
$footer_text_container->addChild(
	"group7",
	$group7
);

$row1 = new HudsonEdgeRow();
$group7->addChild(
	"row1",
	$row1
);

$footer_bottom_link_color = new HudsonEdgeField(
	"colorsimple",
	"footer_bottom_link_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"footer_bottom_link_color",
	$footer_bottom_link_color
);

$footer_bottom_link_font_size = new HudsonEdgeField(
	"textsimple",
	"footer_bottom_link_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"footer_bottom_link_font_size",
	$footer_bottom_link_font_size
);

$footer_bottom_link_line_height = new HudsonEdgeField(
	"textsimple",
	"footer_bottom_link_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"footer_bottom_link_line_height",
	$footer_bottom_link_line_height
);

$footer_bottom_link_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"footer_bottom_link_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row1->addChild(
	"footer_bottom_link_text_transform",
	$footer_bottom_link_text_transform
);

$row2 = new HudsonEdgeRow( true );
$group7->addChild(
	"row2",
	$row2
);

$footer_bottom_link_font_family = new HudsonEdgeField(
	"fontsimple",
	"footer_bottom_link_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"footer_bottom_link_font_family",
	$footer_bottom_link_font_family
);

$footer_bottom_link_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"footer_bottom_link_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"footer_bottom_link_font_style",
	$footer_bottom_link_font_style
);

$footer_bottom_link_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"footer_bottom_link_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"footer_bottom_link_font_weight",
	$footer_bottom_link_font_weight
);

$footer_bottom_link_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"footer_bottom_link_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"footer_bottom_link_letter_spacing",
	$footer_bottom_link_letter_spacing
);

$row3 = new HudsonEdgeRow( true );
$group7->addChild(
	"row3",
	$row3
);

$footer_bottom_link_hover_color = new HudsonEdgeField(
	"colorsimple",
	"footer_bottom_link_hover_color",
	"",
	esc_html__( "Hover Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"footer_bottom_link_hover_color",
	$footer_bottom_link_hover_color
);